﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class LegendDisplayer : MonoBehaviour, IPointerEnterHandler, ISelectHandler
{
    public string LegendA;  //The text to show on legend A
    public string LegendB;  //The text to show on legend B
    public string LegendX;  //The text to show on legend X
    public string LegendY;  //The text to show on legend Y

    public void OnSelect(BaseEventData eventData)
    {
        OnControllerButtonFocus();
    }

    public void OnPointerEnter(PointerEventData eventData)
    {
        OnControllerButtonFocus();
    }

    private void OnControllerButtonFocus()
    {
        if (InputManager.Instance != null && InputManager.Instance.InputState == Constants.InputState.Controller && LegendManager.Instance != null)
        {
            //We have all managers and we're using a controller
            if (LegendA != null && LegendA != "")
            {
                //Legend A has text, show it
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.A].Show();
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.A].SetText(LegendA);
            }

            else
            {
                //No text, hide it
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.A].Hide();
            }

            if (LegendB != null && LegendB != "")
            {
                //Legend B has text, show it
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.B].Show();
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.B].SetText(LegendB);
            }

            else
            {
                //No text, hide it
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.B].Hide();
            }

            if (LegendX != null && LegendX != "")
            {
                //Legend X has text, show it
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.X].Show();
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.X].SetText(LegendX);
            }

            else
            {
                //No text, hide it
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.X].Hide();
            }

            if (LegendY != null && LegendY != "")
            {
                //Legend Y has text, show it
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.Y].Show();
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.Y].SetText(LegendY);
            }

            else
            {
                //No text, hide it
                LegendManager.Instance.ControllerButtons[ControllerLegendButtons.Y].Hide();
            }
        }
    }
}
